<?php
namespace Core;

class Bootstrap {
    public function __construct() {
        // Load config
        $this->loadEnv();
        $this->loadHelpers();

        // Load Router
        require_once __DIR__ . '/Router.php';
    }

    private function loadEnv() {
        if (file_exists(__DIR__ . '/../.env')) {
            $lines = file(__DIR__ . '/../.env', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                if (strpos(trim($line), '#') === 0) continue;
                putenv(trim($line));
            }
        }
    }

    private function loadHelpers() {
        if (file_exists(__DIR__ . '/Helpers.php')) {
            require_once __DIR__ . '/Helpers.php';
        }
    }

    public function run() {
        // Start Router
        $router = new Router();
        $router->dispatch();
    }
}
