<?php
namespace Core;

class Router {
    private $routes = [];

    public function __construct() {
        // Load routes from config
        $routesFile = __DIR__ . '/../config/routes.php';
        if (file_exists($routesFile)) {
            $this->routes = require $routesFile;
        }
    }

    public function dispatch() {
        $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

        if (isset($this->routes[$uri])) {
            $callback = $this->routes[$uri];
            echo call_user_func($callback);
        } else {
            http_response_code(404);
            echo "404 Not Found";
        }
    }
}
